#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2000,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# @(#)82   1.34   src/csm/install/csmsetup.pm.perl, setup, csm_rcyg 11/9/01 11:45:41
use strict;
BEGIN { $::csmpm = $ENV{'CSM_PM'} ? $ENV{'CSM_PM'} : '/opt/csm/pm'; }
#
# THE FOLLOWING LINE SHOULD BE UNCOMMENTED IF NETADDR WILL BE USED.
# IT IS NEEDED FOR DETERMINING THE SUBNET IN THE DHCPD.CONF FILE.
#
#use NetAddr::IP qw($Always_Display_Mask $Use_CIDR_Notation);
#
use lib $::csmpm;
require NodeUtils;

#---------------------
# Global Variables
#---------------------
# Put these in BEGIN so they are defined early and can be used by others
BEGIN
  {
	$::CSMETC			= "/etc/opt/csm";
	$::CSMLOG			= "/var/log/csm";
	$::CSMTOP			= "/opt/csm";
	$::CSMBIN			= $::CSMTOP . "/bin";
	$::CSMCSMBIN			= $::CSMTOP . "/csmbin";
	$::CSMREQS			= $::CSMTOP . "/reqs";
	$::CSMINSTALLDIR		= $::CSMTOP . "/install";
	$::CREATENODE			= $::CSMCSMBIN . "/createnode";
	$::DEFINENODE			= $::CSMBIN . "/definenode";
	$::INSTALLNODE			= $::CSMBIN . "/installnode";
	$::MONITORINSTALL		= $::CSMBIN . "/monitorinstall";
	$::LSNODE			= $::CSMBIN . "/lsnode";
	$::LSNODES			= $::CSMBIN . "/lsnodes";
	$::CHNODE			= $::CSMBIN . "/chnode";
	$::MAKENODE			= $::CSMBIN . "/makenode";
	$::SETUPCONSOLE			= $::CSMBIN . "/setupconsole";
	$::RPOWER			= $::CSMBIN . "/rpower";
	$::CSMSETUP_PM			= $::CSMBIN . "/csmsetup.pm";
	$::HWConfigFile			= $::CSMETC . "/hwconfig";
	$::LUISCRIPT			= $::CSMETC . "/lui.script.generated";
	$::DHCPDFILE			= $::CSMETC . "/dhcpd.conf";
	$::INSTALLNODE_LOG		= $::CSMLOG . "/installnode.log";
	$::MAKENODE_LOG			= $::CSMLOG . "/makenode.log";
	$::TFTPBOOT			= "/tftpboot";
	$::TFTPBOOT_BIN			= $::TFTPBOOT . "/bin";
	$::TFTPBOOTRPM			= $::TFTPBOOT . "/rpm";
	$::LUI_VERSION			= "1.8";
	$::LUITOP			= "/usr/local/lui-" . $::LUI_VERSION;
	$::ATFTP                        = "/usr/bin/atftp";
	$::CHMOD			= "/bin/chmod";
	$::COPY				= "/bin/cp";
	$::MOVE				= "/bin/mv";
	$::HEAD				= "/usr/bin/head";
	$::LS				= "/bin/ls";
	$::LN				= "/bin/ln";
	$::RM				= "/bin/rm";
	$::MKDIR			= "/bin/mkdir";
	$::MOUNT			= "/bin/mount";
	$::UNMOUNT			= "/bin/umount";
	$::GREP				= "/bin/grep";
	$::NETSTAT			= "/bin/netstat";
	$::SERVICE                      = "/sbin/service";
	$::LSOF                         = "/usr/sbin/lsof";
	$::ESPTTY			= "/usr/bin/esptty";
	$::DSH				= "/opt/csm/bin/dsh";
	$::RPMCMD			= "/bin/rpm";
	$::PING				= "/bin/ping";
	$::TOUCH			= "/bin/touch";
	$::SLEEP			= "/bin/sleep";

$::ClusterConfigTemplateFile	= "cluster.config.template";
$::ClusterConfigFile		= "cluster.config.generated";
$::DEFAULT_RPMSOURCE		= $::CSMINSTALLDIR . "/distrib";
$::DEFAULT_NETMASK		= "255.255.255.0";
$::DEFAULT_INSTALLMETHOD	= "csmonly";
$::DEFAULT_HWTYPE		= "netfinity";
$::DEFAULT_POWERMETHOD		= "netfinity";
$::DEFAULT_CONSOLEMETHOD	= "esp";
$::DEFAULT_CONSOLESTARTPORT	= "0";
$::DEFAULT_CONSOLENUMPORTS	= "16";
$::DEFAULT_NUMSP		= 10;
$::DEFAULT_STARTSP		= "node01";
$::NONE				= "none";

$::PXELINUX_CFG_DIR		= "/tftpboot/pxelinux.cfg";

# The default Linux distribution to install (change this with -d flag)
#$::DEFAULT_DISTRO = 'RedHat 7.1';

# List of supported distributions (these must match what is returned by
# NodeUtils->distribution())
@::VALID_DISTROS  = (
		  'RedHat 6.2',
		  'RedHat 7.0',
		  'RedHat 7.1',
		  'RedHat 7.2',
		  );

$::DISTRO = "";

# The human-readable name of the distribution
$::DISTRO_NAME{'RedHat 6.2'}	= "Red Hat Linux 6.2";
$::DISTRO_NAME{'RedHat 7.0'}	= "Red Hat Linux 7.0";
$::DISTRO_NAME{'RedHat 7.1'}	= "Red Hat Linux 7.1";
$::DISTRO_NAME{'RedHat 7.2'}	= "Red Hat Linux 7.2";

$::DISTRO_SHORTNAME{'RedHat 6.2'}	= "rh62";
$::DISTRO_SHORTNAME{'RedHat 7.0'}	= "rh70";
$::DISTRO_SHORTNAME{'RedHat 7.1'}	= "rh71";
$::DISTRO_SHORTNAME{'RedHat 7.2'}	= "rh72";

$::DISTRO_SHORTNAMEKS{'RedHat 6.2'}	= "ks62";
$::DISTRO_SHORTNAMEKS{'RedHat 7.0'}	= "ks70";
$::DISTRO_SHORTNAMEKS{'RedHat 7.1'}	= "ks71";
$::DISTRO_SHORTNAMEKS{'RedHat 7.2'}	= "ks72";

# A list of numbers corresponding to the number of CD-ROMs in the distribution
$::DISTRO_DISKLIST{'RedHat 6.2'}	= "1";
$::DISTRO_DISKLIST{'RedHat 7.0'}	= "1 2";
$::DISTRO_DISKLIST{'RedHat 7.1'}	= "1 2";
$::DISTRO_DISKLIST{'RedHat 7.2'}	= "1 2";

# The directory under which the RPMs reside on the RedHat distribution CD-ROM(s)
$::DISTRO_RPMDIR{'RedHat 6.2'}	= "RedHat/RPMS";
$::DISTRO_RPMDIR{'RedHat 7.0'}	= "RedHat/RPMS";
$::DISTRO_RPMDIR{'RedHat 7.1'}	= "RedHat/RPMS";
$::DISTRO_RPMDIR{'RedHat 7.2'}	= "RedHat/RPMS";

# The redhat*_prereqs should be already on the RedHat CD(s).
# These are the files that are common among all distro levels
@::common_prereqs = (
					  'glibc-*.rpm',
					  'libstdc++-*.rpm',
					  'perl-5*.rpm',
					  'make-*.rpm',
					  'nfs-utils-*.rpm',
					  'pdksh-*.rpm',
					 'pidentd-*.rpm',
					 'tetex-fonts-*.rpm',
					 'tetex-1*.rpm',
					 'tetex-dvips-*.rpm',
					 'tetex-latex-*.rpm',
					 'dialog-*.rpm',
					 'ed-*.rpm',
					 'dhcp-*.rpm',
					);

# Prereqs that come with RedHat 6.2
@::redhat62_prereqs = @::common_prereqs;

# Prereqs required for LUI and redhat 6.2
@::redhat62_lui_prereqs = (
		"lui-1.8-2.i386",
		"perl-Tk-800.018-1.i386",
		"inetd-0.16-4.i386",
		"nfs-utils-0.1.6-2.i386",
		"dhcp-2.0-5.i386",
		);

# Prereqs that come with RedHat 7
@::redhat70_prereqs = @::common_prereqs;
#@::redhat71_prereqs = (@::common_prereqs, 'perl-DBI-*.rpm');
@::redhat71_prereqs = (@::common_prereqs);

# Prereqs required for LUI and redhat 7
@::redhat7_lui_prereqs = (
		"lui-1.8-2.i386",
		"perl-Tk-800.018-1.i386",
		"xinetd-2.1.8.9pre9-6.i386",
		"nfs-utils-0.1.9.1-7.i386",
		"dhcp-2.0-12.i386",
		);

$::DISTRO_PREREQS{'RedHat 6.2'}	= [@::redhat62_prereqs];
$::DISTRO_PREREQS{'RedHat 7.0'}	= [@::redhat70_prereqs];
$::DISTRO_PREREQS{'RedHat 7.1'}	= [@::redhat71_prereqs];
$::DISTRO_PREREQS{'RedHat 7.2'}	= [@::redhat71_prereqs];


# Attributes associated with each node that must be provided to CSM.
@::CSMNodeAttrs = (
    "HWControlPoint",
    "PowerMethod",
    "SvcProcName",
    "HWType",
    "ConsoleServerName",
    "ConsoleServerNumber",
    "ConsolePortNum",
    "ConsoleMethod",
    "InstallMethod",
);
#@::CSMNodeAttrs = (
#    "MgmtSvcProcName",
#    "SvcProcName",
#    "HWType",
#    "ConsoleServerName",
#    "ConsolePortNum",
#);

$::MSGS = 
{
    CANT_READ_FILE	=> 'Cannot open %s for reading',
    CANT_WRITE_FILE	=> 'Cannot open %s for writing',
    FILE_NOT_FOUND	=> 'File not found: %s',
    CANT_RUN		=> 'Cannot run %s',
    IPADDR_ERROR	=> 'IP address (%s) out of valid range.',
    GENERATING_DHCPDCONF=> 'Generating DHCPD Config File %s',
    GENERATING_LUISCRIPT=> 'Generating LUI Script %s',
    STARTING_SERVICES	=> 'Starting Services',
    RETURN_CODE		=> 'return code %s',
    ENTER_STARTING_NODENAME => 'Enter starting node name (hostname or IP address):  ',
    ENTER_NUMNODES	=> 'Enter number of nodes to define (default = 1):  ',
    ENTER_VALID_NUMNODES=> 'Please enter a positive whole number',
    ENTER_NODEDEF_FILENAME => 'Enter the filename containing a list of node definitions:  ',
    ENTER_HWCTRLPTS	=> 
	"Enter list of Hardware Control Points (press ENTER for none):\n" .
	"        Format:  hwctrlpt[:method:spname][,...]\n" .
	"                 hwctrlpt = Hardware Control Point hostname\n" .
	"                            or IP address.\n" .
	"                 method   = Power method (default=netfinity)\n" .
	"                 spname   = Starting service processor name\n" .
	"                            or 'hostname' (default=node01)\n" .
	"        Example: hwctrlpt1::node06,hwctrlpt2,hwctrlpt3\n" .
	"        Example: hwctrlpt1::hostname,hwctrlpt2::hostname\n",
    ENTER_CONSOLESERVERS => 
        "Enter list of Console Servers (press ENTER for none):\n" .
	"        Format: csname[:method:csnum:port][, ...]\n" .
	"                csname = Console server name (hostname or IP address)\n" . 
	"                method = Console method (default=esp)\n" .
	"                csnum  = Console server number (default=1)\n" .
	"                port   = Starting console port number (default=0)\n" .
	"        Example: cs1:::4,cs2:conserver,cs3\n",
    ENTER_HWTYPE	=> 'Enter Hardware Type (default = %s):  ',
    ENTER_INSTALLMETHOD	=> 'Enter Install Method (csmonly or kickstart, default = %s):  ',
    INVALID_INSTALLMETHOD => 'Invalid Install Method %s.  Valid values are csmonly and kickstart',
    ENTER_NETMASK	=> 'Enter Netmask (default = %s):  ',
    ENTER_GATEWAY	=> 'Enter Gateway IP Address:  ',

    NODES_ALREADY_INSTALLED => '%s nodes already installed',
    NODES_TO_BE_INSTALLED => '%s nodes to be installed',
    RPM_ALREADY_INSTALLED => '%s is already installed',
    INSTALLING_RPMS	=> 'Installing %s RPMs:',
    INSTALLING_RPM	=> 'Installing %s',
    INSTALLING_RPM_REQS	=> 'Installing the following rpms required by %s:  %s',
    NODE_STATUS		=> 'Node %s : %s',
    PREINSTALL_STATUS	=> 'Status of nodes before the install:',
    POSTINSTALL_STATUS	=> 'Status of nodes after the install:',
    ERROR_STARTING_SERVICE => 'Error starting %s service',
    STARTING_SERVICES	=> 'Starting services',
    STARTING_SERVICE	=> '%s is not running.  Starting service.',
    LINKING_TARBALLS	=> 'Linking tarball requisites to %s',
    INSTALLING_TARBALLS	=> 'Installing tarball requisites for %s',
    SETTING_MS		=> 'Setting Management Server to %s',
    NODE_INSTALL_SUCCESS => 'Node Install - Successful',
    NODE_INSTALL_FAILURE => 'Node Install - Failed',
    RUNNING_INSTALL_MONITOR => 'Running Installation Monitor',
    RMC_FAILED		=> 'Can not execute RMC command:  %s.  Error message from RMC:  %s.',
    RMC_CMD		=> "RMC cmd = %s",
    CMD			=> "\t%s",
    OUTPUT		=> "%s",
    CMD_FAILED		=> 'Can not execute command:  %s.  Error message:  %s.',
    RETURN_CODE		=> 'Return code %s',
    CMD_FAILED_RC	=> 'Command failed:  %s.  Return code:  %s.',
    NEW_NODES_TO_DEFINE	=> 'New Nodes to define:',
    EXISTING_MANAGEDNODES => 'Existing Managed Nodes:',
    EXISTING_PREMANAGEDNODES => 'Existing PreManaged Nodes:',
    PORTNUM_IN_HEX	=> "The starting console port number %s must be a hexidecimal digit",
    ALL_PORTS_AVAILABLE	=> 'All requested ports are available for console server %s',
    PORTS_IN_USE	=> "The following requested ports\nfor console server %s\nare already assigned to existing nodes:",
    INSUFFICIENT_PORTS	=> '%s nodes were specified, but only %s console ports are available',
    ASSIGNING_CONSOLE_PORT => 'Assigning console %s, num %s, port %s to node %s',
    ERROR_ASSIGNING_PORTS => 'Cannot assign console ports to nodes',
    ALREADY_DEFINED_MANAGEDNODES => "The following nodes are already defined as ManagedNodes:\n%s",
    ALREADY_DEFINED_PREMANAGEDNODES => "The following nodes are already defined as PreManagedNodes:\n%s",
    DUPLICATE_NODES	=> 'Nodes are already defined.',
    INVALID_STARTSP	=> 'Invalid starting service processor name format: %s',
    ERROR_ASSIGNING_SP	=> 'Cannot assign service processors to nodes',
    ASSIGNING_SP	=> 'Assigning HWControlPoint:SvcProcName %s:%s to node %s',
    SPNAMES_IN_USE	=> "The following requested service processors\nattached to Hardware Control Point %s\nare are already assigned to existing nodes:",
    ALL_SPNAMES_AVAILABLE => 'All requested service processors are available for Hardware Control Point %s',
    INSUFFICIENT_SP	=> '%s nodes were specified, but only %s service processors are available',
    ERROR_ASSIGNING_HWTYPE => 'Cannot assign hardware types to nodes',
    ERROR_ASSIGNING_INSTALLMETHOD => 'Cannot assign install method to nodes',
    NETFIN_FILE_LINE	=> '%s:%s:%s:%s',
    ADDING_NODES	=> 'Adding CSM Nodes:',
    ADDING_NODE		=> 'Adding Node %s(%s)',
    WRITING_LOGFILE	=> 'Output log is being written to %s',
    START_LOGGING	=> 'Logging started %s',
    STOP_LOGGING	=> 'Logging stopped %s',
    CANT_DSH_NODE	=> 'Cannot run dsh on node %s',
    NOT_INSTALLING_NODE	=> 'Not installing node %s',
    MISSING_MS		=> "Management server must be provided",
    CANT_CREATE_TFTPBOOT => "Cannot create /tftpboot directory",
    CANT_MOUNT_TFTPBOOT	=> "Cannot mount /tftpboot directory",
	REQUIRE => 'Rpm %s requires: %s',
	INSTALLED => 'Installed version of %s is %s.',
	FOUND => 'Found rpm %s, which is %s %s.',
	CANT_FIND_RPM => 'Can not find a version of the %s rpm with the condition: %s %s. (This is required by %s).',
    VERSION_COMPARE_PROBLEM => 'Trouble comparing %s.  Eval message: %s',
    COMPARING_VERSION => 'Comparing versions %s and result is %s.',
    UNSUPPORTED_DISTRO => 'Linux distribution, %s, is not currently supported by CSM.  Supported distributions are:  %s.',
    DETECTED_DISTRO => 'Detected Linux distribution %s.',
    FOUND_RPM => 'Found %s in %s',
    CANT_START_DHCP	=> 'Cannot start dhcp daemon',
    CANT_START_TFTP	=> 'Cannot start tftp daemon',
    INVALID_OSTYPE => 'Invalid Operating System Type. Valid values are Linux or AIX.',
};
}    # end of BEGIN

# Trim whitespace from both ends of a string (string may be multiline)
sub trim
{
    my ($str) = @_;

    $str =~ s/^\s*(.*?)\s*$/$1/mg;
    return $str;
}

# Backup the current logfile.
# Move logfile to logfile.1.  
# Shift all other logfiles (logfile.[1-3]) up one number. 
# The original logfile.4 is removed.
sub backup_logfile
{
    my ($logfile) = @_;

    my ($logfile1) = $logfile . ".1";
    my ($logfile2) = $logfile . ".2";
    my ($logfile3) = $logfile . ".3";
    my ($logfile4) = $logfile . ".4";

    if (-f $logfile)
    {
	rename ($logfile3, $logfile4) if (-f $logfile3);
	rename ($logfile2, $logfile3) if (-f $logfile2);
	rename ($logfile1, $logfile2) if (-f $logfile1);
	rename ($logfile,  $logfile1) if (-f $logfile);
    }
}

# Start logging messages to a logfile.
# Set the LOG_FILE_HANDLE global variable so that all messages get sent to
# a logfile in addition to the screen.
sub start_logging
{
    my ($logfile) = @_;

    &backup_logfile($logfile);

    mkdir ($::CSMLOG, 0644);

    open (LOGFILE, ">$logfile")
	|| NodeUtils->msg($::MSGS, "E2", 'CANT_WRITE_FILE', $logfile);

    $::LOG_FILE_HANDLE = \*LOGFILE;

    # Print the date to the top of the logfile
    NodeUtils->msg($::MSGS, "I", 'WRITING_LOGFILE', $logfile);
    NodeUtils->msg($::MSGS, "LI", 'START_LOGGING', `/bin/date`);

    return ($::LOG_FILE_HANDLE);
}

# Turn off message logging
sub stop_logging
{
    # Print the date at the bottom of the logfile
    NodeUtils->msg($::MSGS, "LI", 'STOP_LOGGING', `/bin/date`);

    close($::LOG_FILE_HANDLE);
    $::LOG_FILE_HANDLE = undef;
}

sub create_csmreqs_dir
{
    my ($dir, $path);
    $path="";

    foreach $dir (split('/', $::CSMREQS))
    {
	$path = "$path/$dir";
	mkdir ($path, 0755);
    }
}

# BEGIN OBSOLETE CODE
sub readHWConfig
{
    # File Format:
    #	1.  MAC address
    #	2.  processor type
    #	3.  number of processors
    #	4.  location in rack
    #	5.  disk type (SCSI or IDE)
    #	6.  number of disk drives
    #	7.  disk sizes (of each drive) (comma separated) in cylinders
    #	8.  service processor port number (or power unit port number)
    #	9.  remote hardware console port number
    #	10. myrinet port number
    #
    # Sample input line
    #   00:A0:C9:06:D6:D7|mp|2|1|scsi|3|527,548,548|1|1|1

    # Open the file and read the hardware configuration for each node into 
    # the @::Nodes array.
    #
    my ($hostnum) = 0;

    open (TABLE, "$::HWConfigFile") 
	|| NodeUtils->msg($::MSGS, "E2", 'CANT_READ_FILE', $::HWConfigFile);
    		# || die "Cannot open " . $::HWConfigFile . " for reading\n";
    while (<TABLE>)
    {
	chop;
	( /^#.*/ ) && next;	# Skip comment lines

	# See if a hostname/IP address was provided for this hwconfig entry
	if (! $::Nodes[$hostnum]) 
	{
	    warn "No IP address provided for hardware configuration ",
		 "file entry $hostnum\n";
	    if ($::ClusterOptions{domainName})
	    {
		$::Nodes[$hostnum] = "host" . ${hostnum} .
					"." . $::ClusterOptions{domainName};
	    }
	    else
	    {
		$::Nodes[$hostnum] = "host" . ${hostnum};
	    }
	}

	(
	    $::Nodes[$hostnum]{"Macaddr"},
	    $::Nodes[$hostnum]{"procType"},
	    $::Nodes[$hostnum]{"numProc"},
	    $::Nodes[$hostnum]{"RackLoc"},
	    $::Nodes[$hostnum]{"diskType"},
	    $::Nodes[$hostnum]{"diskNum"},
	    $::Nodes[$hostnum]{"diskSizes"},
	    $::Nodes[$hostnum]{"ServprocPortnum"},
	    $::Nodes[$hostnum]{"RemotehwConsolePortnum"},
	)	= split('\|', $_);

	$hostnum++;
    }
    close TABLE

}	# readHWConfig

sub displayHWConfig
{
    my ($attribute, $n);

    for $n ( 0 .. $#::Nodes )
    {
	foreach $attribute (sort keys %{$::Nodes[$n]})
	{
	    print "host ", $::Nodes[$n]{host}, " : $attribute \t= ",
		    $::Nodes[$n]{$attribute}, "\n";
	}
    }
}

sub writeHWConfig
{
}
# END OBSOLETE CODE


# Increment an IP address by 1, carrying to the previous octet as required.
# This code originally appeared in the LUI product (luiapi.pm)
sub inc_ip{
    my $ip=$_[0];
    my ($a,$b,$c,$d);
    ($a,$b,$c,$d)=split(/\./,$ip);
    $d++;
    if ($d > 255) {
	$d = $d - 256;
	$c++;
	if ($c > 255) {
	    $c = $c - 256;
	    $b++;
	    if ($b > 255) {
		$b = $b - 256;
		$a++;
		if ($a > 255) {
		    NodeUtils->msg($::MSGS, "E", 'IPADDR_ERROR', "$a.$b.$c.$d");
		    #printf "Error - ip address out of valid range.\n";
		    return 1;
		}
	    }
	}
    }
    return $a."\.".$b."\.".$c."\.".$d;
} #inc_ip

###########################################################################
=item genHex
 sub genhex - Generates a hex representation of an ip address:
 For example, 9.114.133.193 --> 097285C1
 Todo: If it errors on a list, keep going ignoring errors.
       Return a list of hex numbers.
=cut
###########################################################################
sub genHex{
    my $host;
    my $uno;
    my $dos;
    my $tres;
    my $cuatro;
    my $hex;
    my %hex;
    foreach $host (@_){
	my $ip =  NodeUtils->getHost($host);            # Get ip address
	($uno, $dos, $tres, $cuatro) = split(/\./, $ip);# Split by the .
	$hex = sprintf("%02X", $uno);                   # put formatted into hex
	$hex .= sprintf("%02X", $dos);
	$hex .= sprintf("%02X", $tres);
	$hex .= sprintf("%02X", $cuatro);
	$hex{$host} = $hex;
    }
    return %hex;
}


sub chkethup{
  my $cmd = "$::NETSTAT -rn | $::GREP eth0";
  unless(`$cmd`){
    print STDERR "Error: eth0 not up and running on Management Server.\n";
    exit 1;
  }
  return;
} 



# verify_tftp:
# check that tftp server is running in /etc/xinetd.  Also check that the
# client program is found in $::ATFTP.

sub verify_tftp {
    my $errors = 0;
    print "atftp: Checking to see that atftp is up and running...\n" if $::VERBOSE;
    if(-e $::ATFTP){
	print "atftp: $::ATFTP found...\n" if $::VERBOSE;   
	my $version = `$::ATFTP -V`;              # see what version
   
	chomp(my @output = `$::LSOF | $::GREP tftp | $::GREP xinetd`);
	if(@output){
	    print "atftp: atftp is running in xinetd...\n" if $::VERBOSE;
	}
	else{
	    print "atftp: doesn't look like tftp is on.\n" if $::VERBOSE;
	    print "atftp: I'll try starting it up...\n" if $::VERBOSE;
	    `$::SERVICE xinetd start`;
	    chomp(my @output = `$::LSOF | $::GREP tftp | $::GREP xinetd`);
	    if(@output){
		print "atftp: Okay, atftp is running now.\n" if $::VERBOSE;
	    }
	    else{
		print "atftp: Sorry, I can't get atftp working.\n" if $::VERBOSE;
		print "atftp: Does /etc/xinetd.d/tftp exist..." if $::VERBOSE;
		if(-f "/etc/xinetd.d/tftp"){
		    print "Yep.\n" if $::VERBOSE;
		    print "...hmmm, I don't know what's wrong.\n" if $::VERBOSE;
		}
		else{ print "Nope. That's one of your problems.\n" if $::VERBOSE }
		print "atftp: ...could you give me a hand?\n" if $::VERBOSE;
		$errors++;
	    }
	}
	
    }
    else{
	print "tftp: I can't find $::ATFTP anywhere.\n";
	$errors++;
    }
    return $errors;
}

# verify_dhcp:
# check that dhcp is up and running.  Right now we don't check the /etc/dhcpd.conf 
# file, since that should've been checked when made.  This function is just for 
# extreme paranoya.

sub verify_dhcp{
	my $errors = 0;
	my @output;
	my $cmd;
	print "dhcp: Checking to see that dhcp is up and running...\n" if $::VERBOSE;
	unless(-f "/var/lib/dhcp/dhcpd.leases"){
	    print "dhcp: missing /var/lib/dhcp/dhcpd.leases\n";
	    unless(-d "var/lib/dhcp"){
		NodeUtils->runcmd("$::MKDIR -p /var/lib/dhcp");
	    }
	    NodeUtils->runcmd("$::TOUCH /var/lib/dhcp/dhcpd.leases");
	}
	$cmd = "$::SERVICE dhcpd status";
	chomp(@output = `$cmd`);
	my @line = split(" ",@output);
	if( grep /running.../, @output){
	    print "dhcp: @output\n" if $::VERBOSE;
	}
	else{
	    print "dhcp: @output\n" if $::VERBOSE;
	    print "dhcp: So we have a little problem here...\n" if $::VERBOSE;
	    print "dhcp: Let's try restarting dhcp.\n" if $::VERBOSE;
	    `$::SERVICE dhcpd start`;
            $cmd = "$::SERVICE dhcpd status";
	    chomp(@output = `$cmd`);
	    if( grep /running.../, @output){
		print "dhcp: @output\n" if $::VERBOSE;
	    }	    
	    else{
		print "dhcp: Sorry, I couldn't get dhcp working.\n";
		$errors++;
	    }
	}
	return $errors;
}






# Write the /etc/dhcpd.conf file
sub write_dhcpdconf
{
    #my ($dhcpdfile) = "/etc/dhcpd.conf";
    my ($dhcpdfile) = $::DHCPDFILE;
    NodeUtils->msg($::MSGS, "I", 'GENERATING_DHCPDCONF', $dhcpdfile);
    #print "Generating DHCPD Config File $dhcpdfile\n";


    # The kernel image might need to be different for different nodes.
    # If so, the bootkernel will have to be inside each host stanza rather
    # than just in the group stanza.
    my $bootkernel = $::LUIResourceGroups[0]{kernel};

    # Get the Management Node IP Address
    my $msipaddr = &msipaddr();

    # Determine the subnet based on the management server's ip address
    # This assumes that all nodes (includeing the management server) are all in
    # the same subnet.
    #
    # THE FOLLOWING CODE SHOULD BE UNCOMMENTED IF WE PUT NETADDR BACK IN,
    # OR IF A NEW WAY IS FOUND TO GENERATE THE SUBNET.
    #my $ipaddr = new NetAddr::IP($msipaddr, $::ClusterOptions{"netmask"});
    #my $subnet = ($ipaddr->enum)[0]->addr_to_string;
    my $subnet = "0.0.0.0";	# TEMPORARY

    # Determine the domain name based on the management server's hostname.
    my $domainName = $::ClusterOptions{"management_server"};
    $domainName =~ s/^.*?\.//;	# Delete up to and including the first dot (.)

    open (DHCPD, ">$dhcpdfile")
	|| NodeUtils->msg($::MSGS, "E2", 'CANT_WRITE_FILE', $dhcpdfile);
    	# || die "Cannot open $dhcpdfile for write\n";
    
    print DHCPD "option subnet-mask ", $::ClusterOptions{"netmask"}, ";\n";
    print DHCPD "option domain-name \"$domainName\";\n";

    print DHCPD "\nsubnet ", $subnet;
	print DHCPD " netmask ", $::ClusterOptions{"netmask"}, " {\n";
    print DHCPD "\tgroup   {\n";
    # Hardcoded filename because that's where LUI always puts it.
    # This may change if LUI 1.6 uses multiple kernels (one per machine)
    print DHCPD "\t\tfilename \"/tftpboot/pxelinux.bin\";\n";
    print DHCPD "\t\tnext-server ", $msipaddr, ";\n";
    print DHCPD "\t\toption dhcp-server-identifier ", $msipaddr, ";\n\n";

    my ($n);
    for $n ( 0 .. $#::Nodes )
    {
	print DHCPD "\t\thost ", $::Nodes[$n]{name}, " {\n";
	print DHCPD "\t\t\thardware ethernet ", $::Nodes[$n]{Macaddr}, ";\n";
	print DHCPD "\t\t\tfixed-address ", $::Nodes[$n]{ipaddr}, ";\n";
	print DHCPD "\t\t}\n";
    }
    print DHCPD "\t}\n";
    print DHCPD "}\n";

    close DHCPD;
}


# Install any rpms that this rpm is dependent on if they are not already on the
# system at the required level.  (The rpm passed in is the whole rpm file name.)
sub installRequiredRpms
  {
	#my ($class, $rpm) = @_;
	my ($rpm) = @_;
	my @reqs = &getRequiredRpms($rpm);
	#print 'reqs=' . join(':', @reqs) . "\n";
	if (scalar(@reqs))        # need to install at least 1 rpm
	  {
		my $reqlist = join(' ', @reqs);
		NodeUtils->msg($::MSGS, 'I', 
				'INSTALLING_RPM_REQS', $rpm, $reqlist);
		my ($cmd) = "$::RPMCMD -U $reqlist";
		$cmd = "$cmd --force" if $::FORCE_INSTALL;
		NodeUtils->runcmd("$cmd");
	  }
  }


# Return the names of any rpms that this rpm is dependent on if they are not already on the
# system at the required level.  The rpm passed in as the 1st arg is the whole rpm file
# name.  The rest of the args are the list of reqs we have already found in previous,
# recursive invokations of the function.
sub getRequiredRpms
  {
	#my ($class, $rpm) = @_;
	my $rpm = shift @_;
	my @reqrpms;
	#my @reqs = &getRequires($rpm);
	my @reqs = &getReqsNotSatisfied($rpm);
	#print "num=" . scalar(@reqs) . ' ,reqs=' . join(':', @reqs) . ".\n";
	foreach my $r (@reqs)
	  {
		my ($pkg, $operator, $version) = split(' ', $r);
		#if (&isInstalled($pkg, $operator, $version)) { next; }

		my $newrpm = &findRpm($pkg, $operator, $version);
		if (defined($newrpm))        # found an appropriate one to install
		  {
			# make sure it is not already on the list
			if (grep(/^$newrpm$/, @_)) { next; }   # already on the list
			
			push @reqrpms, $newrpm;
			
			push @reqrpms, &getRequiredRpms($newrpm, @reqrpms);
		  }
		else { NodeUtils->msg($::MSGS, 'E11', 'CANT_FIND_RPM', $pkg, $operator, $version, $rpm); }
	  }
	return @reqrpms;
  }


# Return the rpms (and versions) that the given rpm requires that are not already on the system
sub getReqsNotSatisfied
  {
	my $rpm = shift @_;
	my @requires;
	my @output = NodeUtils->runcmd("$::RPMCMD -i --test $rpm", -1);
	if ($::RUNCMD_RC == 0) { return @requires; }    # all dependencies were satisfied
	if ($::RUNCMD_RC > 1) { return @requires; }
	my $firstline = shift @output;
	if ($firstline=~/is already installed/) { return @requires; }
	if (!($firstline=~/failed dependencies/)) { return @requires; }
	
	foreach my $o (@output)
	  {
		#print "o=$o\n";
		my ($pkg, $operator, $version) = &parseRequire($o);
		#print "pkg=$pkg, operator=$operator, version=$version\n";
		if (!defined($pkg)) { next; }   # was not an rpm require
		
		# Hack for glibc version because I can not find a way to have the require
		# statement in the rpm be different for different distribution levels.
		if ($pkg eq 'glibc' && NodeUtils->distribution()=~/^RedHat 7/i)
		  { $o = "$pkg $operator 2.2"; }

		my $req = "$pkg $operator $version";
		NodeUtils->msg($::MSGS, 'V', 'REQUIRE', $rpm, $req);
		push(@requires, $req);
	  }
	return @requires;
  }


# Parse a single require line, distinguishing between rpms and individual libraries
# of executables.
sub parseRequire
  {
	my $line = shift @_;
	$line =~ s/ is needed by .*$//;
	my ($pkg, $operator, $version, $therest) = split(' ', $line);
	if ($pkg=~/^rpmlib/ || $pkg=~m|/| || $pkg=~/\.so/) { return undef; }
	else { return ($pkg, $operator, $version); }
  }


# NOTE: NOT USED RIGHT NOW
# Return the rpms (and versions) that the given rpm requires
sub getRequires
  {
	#my ($class, $rpm) = @_;
	my ($rpm) = @_;
	my @requires;
	my @output = NodeUtils->runcmd("$::RPMCMD -qRp $rpm");
	foreach my $o (@output)
	  {
		#print "o=$o\n";
		my ($pkg, $operator, $version) = &parseRequire($o);
		#print "pkg=$pkg, operator=$operator, version=$version\n";
		if (!defined($pkg)) { next; }   # was not an rpm require
		
		# Hack for glibc version because I can not find a way to have the require
		# statement in the rpm be different for different distribution levels.
		if ($pkg eq 'glibc' && NodeUtils->distribution()=~/^RedHat 7/i)
		  { $o = "$pkg $operator 2.2"; }
		
		NodeUtils->msg($::MSGS, 'V', 'REQUIRE', $rpm, $o);
		push(@requires, $o);
	  }
	return @requires;
  }


# NOTE: NOT USED RIGHT NOW
# Determine whether or not the rpm of the required version is installed
sub isInstalled
  {
	#my ($class, $pkg, $operator, $version) = @_;
	my ($pkg, $operator, $version) = @_;
	my $rpm = NodeUtils->runcmd("$::RPMCMD -q $pkg", -1);
	if ($::RUNCMD_RC || !length($rpm)) { return 0; }
	if (!length($operator) || !length($version)) { return 1; }   # does not matter what version
	#my ($ipkg, $iversion, $irelease) = split('-', $rpm);
	my ($ipkg, $iversion, $irelease) = $rpm =~ /^(.+)-(\d.*)-(.*)$/;
	if (!length($iversion)) { return 0; }
	NodeUtils->msg($::MSGS, 'V', 'INSTALLED', $pkg, $iversion);
	return &testVersion($iversion, $operator, $version);
  }

# Find the rpm package in the given path
sub findRpmInPath
  {
	my ($rpmfile, @path) = @_;
	foreach my $p (@path)
	  {
	    my $filename = "$p/$rpmfile";
		# use the ls command here instead of the -e operator so we can handle *s in the names
		#print "looking for $filename: ", `/bin/ls $filename`, "\n";
	    if (`/bin/ls $filename 2> /dev/null`)
		  {
			NodeUtils->msg($::MSGS, 'V', 'FOUND_RPM', $rpmfile, $p);
			return $p;
		  }
	  }
	return undef;
  }


# Try to find and return the rpm file that is the required version
sub findRpm
  {
	#my ($class, $pkg, $operator, $version) = @_;
	my ($pkg, $operator, $version) = @_;

	# Get the current distribution if it was not already obtained.
	my $distro = $::DISTRO;
	if (! $distro)
	{
	    $distro = NodeUtils->distribution();
	    if (!grep(/^$distro$/, @::VALID_DISTROS))
	    {
		NodeUtils->msg($::MSGS, 'E5', 'UNSUPPORTED_DISTRO', 
				$distro, join(', ',@::VALID_DISTROS));
	    }
	    else 
	    {
		NodeUtils->msg($::MSGS, 'V', 'DETECTED_DISTRO', $distro);
	    }
	}

        # note: The -vr options on the ls command gives us the entries in
        #       reverse version order to get the latest version first.
	my @rpms;

	# Look for the rpm in /tftpboot/rpm
        my @rpms1 = NodeUtils->runcmd("$::LS -vr $::TFTPBOOTRPM/$pkg-*", -1);
	my $rc1 = $::RUNCMD_RC;
	if (! $rc1) { @rpms = (@rpms, @rpms1); } # Only add if no errors

	# Look for the rpm in /tftpboot/<distro>/RedHat/RPMS
	my $TFTPBOOT_DISTRORPM = "$::TFTPBOOT/$::DISTRO_SHORTNAME{$distro}/$::DISTRO_RPMDIR{$distro}";
        my @rpms2 = NodeUtils->runcmd("$::LS -vr $TFTPBOOT_DISTRORPM/$pkg-*", -1);
	my $rc2 = $::RUNCMD_RC;
	if (! $rc2) { @rpms = (@rpms, @rpms2); } # Only add if no errors

	if (($rc1 && $rc2) || !scalar(@rpms)) { return undef; }
	#if ($::RUNCMD_RC || !scalar(@rpms)) { return undef; }

	foreach my $r (@rpms)
	  {
		#my ($ipkg, $iversion, $irelease) = split('-', $r);
		my ($fn) = $r =~ m|^.*?([^/]+)$|;      # get rid of the directory, if any
		#print "fn=$fn\n";
		my ($ipkg, $iversion, $irelease) = $fn =~ /^(.+)-(\d.*)-(.*)$/;
		#print "ipkg=$ipkg, iversion=$iversion, irelease=$irelease\n";
		# Note: irelease has .i386.rpm on the end of it
		if ($ipkg ne $pkg || !length($iversion)) { next; }
		if (!length($operator) || !length($version) || &testVersion($iversion, $operator, $version))
		  {
			NodeUtils->msg($::MSGS, 'V', 'FOUND', $r, $operator, $version);
			return $r;
		  }
	  }
	return undef;   # didn't find a suitable rpm
  }


# Compare version1 and version2 according to the operator and return true or false.
# These expressions come from the Require statement of our rpms.
sub testVersion
  {
	#my ($class, $version1, $operator, $version2, $release1, $release2) = @_;
	my ($version1, $operator, $version2, $release1, $release2) = @_;

	# Note: perl seems to be able to handle really big integers, but if we run into a limit, we
	#       can use the Math::BigInt pkg

	my @a1 = split(/\./, $version1);
	my @a2 = split(/\./, $version2);
	my $len = (scalar(@a1)>scalar(@a2) ? scalar(@a1) : scalar(@a2));
	$#a1 = $len -1;      # make the arrays the same length before appending release
	$#a2 = $len -1;
	push @a1, split(/\./, $release1);
	push @a2, split(/\./, $release2);
	$len = (scalar(@a1)>scalar(@a2) ? scalar(@a1) : scalar(@a2));
	my $num1 = '';
	my $num2 = '';

	for (my $i=0; $i<$len; $i++)
	  {
		my ($d1) = $a1[$i] =~ /^(\d*)/;     # remove any non-numbers on the end
		my ($d2) = $a2[$i] =~ /^(\d*)/;
		
		my $diff = length($d1) - length($d2);
		if ($diff > 0)     # pad d2
		  {
			$num1 .= $d1;
			$num2 .= ('0' x $diff) . $d2;
		  }
		elsif ($diff < 0)     # pad d1
		  {
			$num1 .= ('0' x abs($diff)) . $d1;
			$num2 .= $d2;
		  }
		else        # they are the same length
		  {
			$num1 .= $d1;
			$num2 .= $d2;
		  }
	  }

	# Remove the leading 0s or perl will interpret the numbers as octal
	$num1 =~ s/^0+//;
	$num2 =~ s/^0+//;

	if (length($release1)) { $release1 = "-$release1"; }   # this is just for error msgs
	if (length($release2)) { $release2 = "-$release2"; }   # this is just for error msgs
	
	if ($operator eq '=') { $operator = '=='; }
	my $bool = eval "$num1 $operator $num2";
	if (length($@))
	  {
		NodeUtils->msg($::MSGS, 'W', 'VERSION_COMPARE_PROBLEM', "$version1$release1 $operator $version2$release2", $@);
		return undef;
	  }
	NodeUtils->msg($::MSGS, 'V', 'COMPARING_VERSION', "$version1$release1 $operator $version2$release2", ($bool?'true':'false'));
	return $bool;
  }


# 
# Calculate the IP address of the management server
#
sub msipaddr
{
    my $mshostname = $::ClusterOptions{'management_server'};
    my $msipaddrpack = gethostbyname $mshostname;
    my ($a, $b, $c, $d) = unpack ('C4', $msipaddrpack);

    my $msipaddr = "$a.$b.$c.$d";
    return $msipaddr;
}

#
# Return the unmasked portion of an IP address
#
sub IPAddressMask
{
    use POSIX qw(strtol);
    my ($ipaddr, $netmask) = @_; 

    my (@ipaddr) = split ('\.', $ipaddr);
    my (@netmask) = split ('\.', $netmask);

    my ($octet, $ipoctet, $maskoctet, $masked);

    for ($octet=0; $octet<4; $octet++) 
    {
	print "$ipaddr[$octet] ($netmask[$octet])    ";

	# Convert the strings to long (numeric) values
	$ipoctet = strtol($ipaddr[$octet]);
	$maskoctet = strtol($netmask[$octet]);
	print "MASKED--->";
	$masked = $ipoctet & $maskoctet;
	print " $masked";
	print "\n";
	
    }
}

sub generate_lui_script
{
    my ($msipaddr, $msshorthost, $n);
    my ($all_nodelist, $up_nodelist, $mp_nodelist);
    my ($scsi_nodelist, $ide_nodelist);

    open (LUISCRIPT, ">$::LUISCRIPT") 
	|| NodeUtils->msg($::MSGS, "E2", 'CANT_WRITE_FILE', $::LUISCRIPT);
    		#|| die "Cannot open $::LUISCRIPT for write\n";
    NodeUtils->msg($::MSGS, "I", 'GENERATING_LUISCRIPT', $::LUISCRIPT);
    #print "Generating LUI Script $::LUISCRIPT\n";

    # Get the Management Node IP Address
    $msipaddr = &msipaddr();
    ($msshorthost = $::ClusterOptions{'management_server'}) =~ s/\..*$//;

    print LUISCRIPT "#!/bin/bash\n";
    print LUISCRIPT "export PATH=" . $::LUITOP . ":\$PATH\n";
    
    # Create the LUI server
    print LUISCRIPT "\n# Define the installation server machine to LUI\n";
    print LUISCRIPT "mklimm -n ", $msshorthost,
			  " -t server",
			  " -i ", $msipaddr,
			  " -m ", $::ClusterOptions{netmask},
			  "\n";

    # Create the nodes (LUI machines)
    print LUISCRIPT "\n# Define the client machine(s) to LUI\n";
    for $n ( 0 .. $#::Nodes )
    {
	print LUISCRIPT "mklimm -n ", $::Nodes[$n]{'name'},
			      " -t client ",
			      " -i ", $::Nodes[$n]{'ipaddr'},
			      " -m ", $::ClusterOptions{'netmask'},
			      " -d ", $::ClusterOptions{'gateway'},
			      " -H ", $::Nodes[$n]{'Macaddr'},
			      " -p ", $::Nodes[$n]{'numProc'},
			      " -a eth0", 
			      " -o ", $::Nodes[$n]{'hostname'},
			      "\n";
    }

    # Create LUI machine groups
    print LUISCRIPT "\n# Create Machine Groups\n";

    # Create all LUI machine group (all machines)
    $all_nodelist = "";
    for $n ( 0 .. $#::Nodes )
    {
	$all_nodelist = ${all_nodelist} . "," . $::Nodes[$n]{'name'};
    }
    $all_nodelist =~ s/^,//;
    $all_nodelist =~ s/,$//;
    ($all_nodelist) &&
	print LUISCRIPT "mklimg -t machine -m $all_nodelist -g all\n";

    # Create uniprocessor LUI machine group
    $up_nodelist = "";
    for $n ( 0 .. $#::Nodes )
    {
	if ($::Nodes[$n]{'numProc'} <= 1)
	{
	    $up_nodelist = ${up_nodelist} . "," . $::Nodes[$n]{'name'};
	}
    }
    $up_nodelist =~ s/^,//;
    $up_nodelist =~ s/,$//;
    ($up_nodelist) &&
	print LUISCRIPT "mklimg -t machine -m $up_nodelist -g uniprocessor\n";

    # Create multiprocessor LUI machine group
    $mp_nodelist = "";
    for $n ( 0 .. $#::Nodes )
    {
	if ($::Nodes[$n]{'numProc'} > 1)
	{
	    $mp_nodelist = ${mp_nodelist} . "," . $::Nodes[$n]{'name'};
	}
    }
    $mp_nodelist =~ s/^,//;
    $mp_nodelist =~ s/,$//;

    ($mp_nodelist) &&
	print LUISCRIPT "mklimg -t machine -m $mp_nodelist -g multiprocessor\n";

    # Create SCSI LUI machine group (machines that have SCSI disks)
    $scsi_nodelist = "";
    for $n ( 0 .. $#::Nodes )
    {
	if ($::Nodes[$n]{'diskType'} =~ /SCSI/i)
	{
	    $scsi_nodelist = ${scsi_nodelist} . "," . $::Nodes[$n]{'name'};
	}
    }
    $scsi_nodelist =~ s/^,//;
    $scsi_nodelist =~ s/,$//;

    ($scsi_nodelist) &&
	print LUISCRIPT "mklimg -t machine -m $scsi_nodelist -g scsi\n";

    # Create IDE LUI machine group (machines that have IDE disks)
    $ide_nodelist = "";
    for $n ( 0 .. $#::Nodes )
    {
	if ($::Nodes[$n]{'diskType'} =~ /IDE/i)
	{
	    $ide_nodelist = ${ide_nodelist} . "," . $::Nodes[$n]{'name'};
	}
    }
    $ide_nodelist =~ s/^,//;
    $ide_nodelist =~ s/,$//;

    ($ide_nodelist) &&
	print LUISCRIPT "mklimg -t machine -m $ide_nodelist -g ide\n";


    # Create the resources
    my($groupname) = "rg";
    my($resourcename) = "";
    my($allresources) = "";
    my($disktable, $rpm);

    print LUISCRIPT "\n# Create Disk Table Resources\n";
    for $disktable ("scsi","ide")
    {
	$resourcename = "${disktable}_disktable";
	print LUISCRIPT "mklimr -n " . $resourcename .
			      " -t disk" .
			      " -d ". $::CSMINSTALLDIR . "/disktable.".$disktable .
			      "\n";
    }

    print LUISCRIPT "\n# Create RPM List Resources\n";
    for $rpm ("up","mp")
    {
	$resourcename = "${rpm}rpm";
	print LUISCRIPT "mklimr -n " . $resourcename .
			      " -t rpm" .
			      " -d " . $::CSMINSTALLDIR . "/rpmlist." . $rpm .
			      "\n";

    }

    print LUISCRIPT "\n# Create RAMDISK Resources\n";
    $resourcename = "upramdisk";
    print LUISCRIPT "mklimr -n ", $resourcename,
			  " -t ramdisk",
			  " -d ", "/boot/initrd-2.2.14-5.0.img",
			  "\n";
    $allresources = "${allresources},$resourcename";

    $resourcename = "mpramdisk";
    print LUISCRIPT "mklimr -n ", $resourcename,
			  " -t ramdisk",
			  " -d ", "/boot/initrd-2.2.14-5.0smp.img",
			  "\n";
    $allresources = "${allresources},$resourcename";
 

    print LUISCRIPT "\n# Define the filesystem resources for LUI resource group \"$groupname\"\n";
    my ($filesystems) = "/ /boot /usr /home /var";
    my ($fs, $fsname, $resourcename, $allresources);

    foreach $fs (split(/\s/, $filesystems))
    {
	my ($fsname) = $fs;
	$fsname =~ s:/:_:g;
	$resourcename = "${groupname}file${fsname}";
	print LUISCRIPT "mklimr -n ", $resourcename,
			      " -t file",
			      " -d ", $fs,
			      " -c ",
			      "\n";
	$allresources = "${allresources},$resourcename";
    }


    print LUISCRIPT "\n# Define other resources for LUI resource group \"$groupname\"\n";


    $resourcename = "${groupname}exit";
    print LUISCRIPT "mklimr -n " . $resourcename .
			  " -t exit" .
			  " -d " . $::CSMINSTALLDIR . "/csmexit" .
			  "\n";
    $allresources = "${allresources},$resourcename";

    $resourcename = "${groupname}source_shadow";
    print LUISCRIPT "mklimr -n ", $resourcename,
			  " -t source",
			  " -d ", "/etc/shadow",
			  " -o ", "/etc/shadow",
			  "\n";
    $allresources = "${allresources},$resourcename";

    $resourcename = "${groupname}source_resolv_conf";
    print LUISCRIPT "mklimr -n ", $resourcename,
			  " -t source",
			  " -d ", "/etc/resolv.conf",
			  " -o ", "/etc/resolv.conf",
			  "\n";
    $allresources = "${allresources},$resourcename";


    # Assign all the resources to this LUI resource group
    print LUISCRIPT "\n# Assign resources to LUI resource group \"$groupname\"\n";
    $allresources =~ s/^,//;
    $allresources =~ s/,$//;
    print LUISCRIPT "mklimg -t resource -m $allresources -g $groupname\n";



    # Allocate the Resources (or resource groups) for each node (or node group)
    print LUISCRIPT "\n# Allocate resources and resource groups to node groups\n";
    # Allocate all the "generic" resources to all machines.
    # Generic resources are those that apply to all machines
    print LUISCRIPT "allimr -r $groupname -g all\n";

    # Allocate specialized resources to specific machine groups
    if ($scsi_nodelist)
    {
	print LUISCRIPT "allimr -n scsi_disktable -g scsi\n";
    }
    if ($ide_nodelist)
    {
	print LUISCRIPT "allimr -n ide_disktable  -g ide\n";
    }
    if ($up_nodelist)
    {
	print LUISCRIPT "allimr -n uprpm          -g uniprocessor\n";
	print LUISCRIPT "allimr -n upramdisk      -g uniprocessor\n";
    }
    if ($mp_nodelist)
    {
	print LUISCRIPT "allimr -n mprpm          -g multiprocessor\n";
	print LUISCRIPT "allimr -n mpramdisk      -g multiprocessor\n";
    }


    close LUISCRIPT;
}

# BEGIN OBSOLETE CODE
# This subroutine may be obsolete.  We might just ship an ide.disktable and
# a scsi.disktable to the $CSMINSTALLDIR directory.  One of these would be used 
# for every machine depending on its disk type.  There will be two LUI machine
# groups, one for ide and one for scsi, the appropriate machines are put in 
# each group, and the appropriate disk resource is allocated to each machine
# group.
sub generate_disktables
{
    my ($disktype, $disknum, @disksizes);
    my ($disktable, $disktype_prefix);
    my ($n, $size);

    for $n ( 0 .. $#::Nodes )
    {
	$disktype  = $::Nodes[$n]{'diskType'};
	$disknum   = $::Nodes[$n]{'diskNum'};
	(@disksizes) = split(/,/, $::Nodes[$n]{'diskSizes'});

	$disktable = $::CSMINSTALLDIR . "/" . $::Nodes[$n]{'name'} . ".disktable";
	open (DISKTABLE, ">$disktable")
		|| die "Cannot open $disktable\n";
	print "Generating Disk Table $disktable\n";
	
	if ($disktype =~ /scsi/i)	{$disktype_prefix = "/dev/sda";}
	elsif ($disktype =~ /ide/i)	{$disktype_prefix = "/dev/hda";}
	else	
	{
	    warn("Invalid disk type $disktype.  Assuming SCSI.\n");
	    $disktype_prefix = "/dev/sda";
	}

	# Get the list of LUI "file" resources for this node
	# For now, just assume we are using the "standard" resources.
	my ($filesystems) = "/boot,/usr,/home,/var,/";
	my ($i) = 1;
	my ($fs);
	foreach $fs (split (/,/, $filesystems))
	{
	    if ($fs =~ /\/boot/)
	    {
		# The boot filesystem
		$size = 3;
		print DISKTABLE "$disktype_prefix", $i++, 
				"\text2\t\t$size\tc\ty\t$fs\n";

		# The extended boot filesystem
		$size = 1000;
		print DISKTABLE "$disktype_prefix", $i++,
				"\textended\t$size\tc\tn\n";
	    }
	    elsif ($fs =~ /(\/)|(\/home)|(\/var)/)
	    {
		# The /(root), /home and /var filesystem
		$size = 100;
		print DISKTABLE "$disktype_prefix", $i++,
				"\text2\t\t$size\tc\tn\t$fs\n";
	    }
	    elsif ($fs =~ /\/usr/)
	    {
		# The /usr filesystem
		$size = 300;
		print DISKTABLE "$disktype_prefix", $i++,
				"\text2\t\t$size\tc\tn\t$fs\n";
	    }
	    else
	    {
		# Any other filesystem
		$size = 100;
		print DISKTABLE "$disktype_prefix", $i++,
				"\text2\t\t$size\tc\tn\t$fs\n";
	    }
	}

	# The swap filesystem
	$size = 20;
	print DISKTABLE "$disktype_prefix", $i++, 
			"\tswap\t\t$size\tc\n";

	close DISKTABLE;
    }
}
# END OBSOLETE CODE

# Start the services needed by LUI (and others?).
sub start_services
{
    NodeUtils->msg($::MSGS, "I", 'STARTING_SERVICES');
    #print "Starting Services\n";

    my (@services) = (
		     "nfs",
		     "dhcpd",
		     "inet",
		     );

    my $status = 0;

    my ($cmd, $rc);
    my ($service);

    # dhcpd needs its lease database created before it can be started.
    my $leases = "/var/state/dhcp/dhcpd.leases";
    if (! -f $leases)
    {
	$cmd = "touch $leases";
	print "\t$cmd\n";
	$rc = system("$cmd") >> 8;
	if ($rc != 0)
	{
	    NodeUtils->msg($::MSGS, "W", 'RETURN_CODE', $rc);
	    #print "return code $rc\n";
	    $status = $rc;
	}
    }


    foreach $service (@services)
    {
	# Start (or restart) the service
	$cmd = "/sbin/service $service restart";
	print "\t$cmd\n";
	$rc = system("$cmd") >> 8;
	if ($rc != 0)
	{
	    NodeUtils->msg($::MSGS, "W", 'RETURN_CODE', $rc);
	    #print "return code $rc\n";
	    $status = $rc;
	}

#	# Check if service is already running, if not, start it.
#	$cmd = "/sbin/service $service status | grep $service | grep 'is running'";
#	$output = `$cmd`;
#	if (! $output)
#	{
#	    print "$service is not running.  Starting service\n";
#
#	    # Start the service
#	    $cmd = "/sbin/service $service start";
#	    print "\t$cmd\n";
#	    $rc = system("$cmd") >> 8;
#	    if ($rc != 0)
#	    {
#		NodeUtils->msg($::MSGS, "W", 'RETURN_CODE', $rc);
#		#print "return code $rc\n";
#		$status = $rc;
#	    }
#
#	}
    }
    print "start_services: Returning with $status\n";
    return $status;
}

# BEGIN OBSOLETE CODE
# Get the list of nodes from RMC that are to be installed.  
# Only install the nodes that are in the PreManagedNode class
# The node list will get stored in the @PreManagedNodes array.
sub get_PreManagedNode_list
{
    my $line = "";
    my $n = 0;

    #my $attributes = "Hostname,Installed";
    my $attributes = "Hostname";
    my $flags = "-P";	# Flag to show premanaged nodes

    open (LSNODES, "$::LSNODES $flags -a$attributes|") 
	|| NodeUtils->msg($::MSGS, "E2", 'CANT_RUN', $::LSNODES);
	# || die "Cannot run $LSNODES\n";
    while (<LSNODES>)
    {
	$line = $_;
	chomp $line;

	(
	    $::Nodes[$n]{"Hostname"},
	    #$::Nodes[$n]{"Installed"},
	)	= split (/,/ , $line);

	$n++;
    }
    close (LSNODES);
}
# END OBSOLETE CODE
